<?php
// tests/acceptance.php
require_once __DIR__ . '/../config/bootstrap.php';
$pdo = get_pdo();

function assert($cond, $msg) {
    if ($cond) {
        echo "PASS: $msg\n";
    } else {
        echo "FAIL: $msg\n";
    }
}

// 1. TRADE_OPEN webhook → WhatsApp message sent/logged
$event = [
    'event' => 'trade_open',
    'login' => '10001',
    'symbol' => 'EURUSD',
    'side' => 'buy',
    'volume' => '1.00',
    'price' => '1.12345',
    'sl' => '1.12000',
    'tp' => '1.13000',
    'ticket' => '123456',
    'open_time' => date('Y-m-d H:i:s'),
    'pnl' => '0.00'
];
$ch = curl_init('http://localhost/webhooks/mt5.php');
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($event));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-MT5-Signature: ' . hash_hmac('sha256', json_encode($event), getenv('WEBHOOK_SECRET'))
]);
$resp = curl_exec($ch);
curl_close($ch);
assert(strpos($resp, 'success') !== false, 'TRADE_OPEN webhook accepted');

// 2. DEPOSIT/ WITHDRAWAL → correct template vars
$deposit = [
    'event' => 'deposit',
    'amount' => '1000',
    'currency' => 'USD',
    'transaction_id' => 'tx123',
    'balance_after' => '5000'
];
$withdrawal = [
    'event' => 'withdrawal',
    'amount' => '500',
    'currency' => 'USD',
    'transaction_id' => 'tx124',
    'balance_after' => '4500'
];
// ...send and check as above

// 3. Toggle off a trigger → no message sent
// ...simulate toggle and check messages table

// 4. Force 429 → dispatcher retries and logs backoff
// ...simulate by mocking WhatsAppClient response

// More checks as needed
