<?php
require_once __DIR__ . '/config/bootstrap.php';
require_once __DIR__ . '/src/WhatsAppClient.php';

echo "=== WhatsApp Connection Test ===\n\n";

// Check credentials
echo "1. Checking credentials...\n";
$token = $_ENV['WA_TOKEN'] ?? getenv('WA_TOKEN');
$phoneId = $_ENV['WA_PHONE_NUMBER_ID'] ?? getenv('WA_PHONE_NUMBER_ID');
$businessId = $_ENV['WA_BUSINESS_ID'] ?? getenv('WA_BUSINESS_ID');

echo "   Token: " . (empty($token) ? "❌ MISSING" : "✓ Set (" . substr($token, 0, 20) . "...)") . "\n";
echo "   Phone ID: " . (empty($phoneId) ? "❌ MISSING" : "✓ $phoneId") . "\n";
echo "   Business ID: " . (empty($businessId) ? "❌ MISSING" : "✓ $businessId") . "\n\n";

if (empty($token) || empty($phoneId)) {
    echo "❌ Missing credentials! Check your .env file\n";
    exit(1);
}

// Test API endpoint reachability
echo "2. Testing Graph API connection...\n";
$testUrl = "https://graph.facebook.com/v17.0/$phoneId";
$ch = curl_init($testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $token"
]);

$resp = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($resp === false) {
    echo "   ❌ CURL Error: $error\n";
    echo "   This usually means:\n";
    echo "   - No internet connection\n";
    echo "   - Firewall blocking Facebook/Meta domains\n";
    echo "   - SSL certificate issues\n\n";
    exit(1);
}

echo "   HTTP Code: $httpCode\n";
if ($httpCode == 200) {
    echo "   ✓ API endpoint reachable\n";
    $data = json_decode($resp, true);
    echo "   Phone: " . ($data['display_phone_number'] ?? 'N/A') . "\n";
    echo "   Quality: " . ($data['quality_rating'] ?? 'N/A') . "\n";
} elseif ($httpCode == 401 || $httpCode == 403) {
    echo "   ❌ Authentication failed - Token is invalid or expired\n";
    echo "   Response: $resp\n\n";
    exit(1);
} elseif ($httpCode == 404) {
    echo "   ❌ Phone Number ID not found\n";
    echo "   Response: $resp\n\n";
    exit(1);
} else {
    echo "   ⚠️  Unexpected response\n";
    echo "   Response: $resp\n\n";
}

echo "\n3. Testing message send (requires phone number)...\n";
echo "   To test sending, use the web interface or run:\n";
echo "   php -r 'require \"config/bootstrap.php\"; require \"src/WhatsAppClient.php\"; ";
echo "\$w = new WhatsAppClient(); list(\$c, \$r) = \$w->sendFreeForm(\"YOUR_PHONE\", \"Test\"); ";
echo "echo \"Code: \$c\\nResponse: \$r\\n\";'\n\n";

echo "=== Test Complete ===\n";
