<?php
// Quick test to verify notifications table exists and is accessible
require_once __DIR__ . '/config/bootstrap.php';

echo "Testing database connection and notifications table...\n\n";

try {
    // Test basic connection
    $pdo = get_pdo();
    echo "✓ Database connection established\n";
    
    // Test if notifications table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'notifications'");
    $table = $stmt->fetch();
    
    if ($table) {
        echo "✓ notifications table exists\n";
        
        // Get table structure
        $stmt = $pdo->query("DESCRIBE notifications");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "✓ Table columns: " . implode(", ", $columns) . "\n";
        
        // Count existing records
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM notifications");
        $count = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "✓ Current notifications count: " . $count['count'] . "\n";
        
        // Check for other required tables
        $stmt = $pdo->query("SHOW TABLES LIKE 'notification_history'");
        if ($stmt->fetch()) {
            echo "✓ notification_history table exists\n";
        } else {
            echo "✗ notification_history table MISSING\n";
        }
        
        $stmt = $pdo->query("SHOW TABLES LIKE 'notification_checkpoints'");
        if ($stmt->fetch()) {
            echo "✓ notification_checkpoints table exists\n";
        } else {
            echo "✗ notification_checkpoints table MISSING\n";
        }
        
        echo "\n✅ Database is ready for notifications!\n";
        echo "\nYou can now:\n";
        echo "1. Open http://localhost:8000\n";
        echo "2. Click 'Create Notification'\n";
        echo "3. Select clients and create rules\n";
        
    } else {
        echo "✗ notifications table NOT FOUND\n";
        echo "Please run ADD_NOTIFICATION_TABLES.sql in phpMyAdmin\n";
    }
    
} catch (PDOException $e) {
    echo "✗ Database error: " . $e->getMessage() . "\n";
    echo "\nNote: If connection times out, the database is not reachable from localhost.\n";
    echo "You can still use the app through your hosted URL.\n";
}
