<?php
// test_mt5_auth.php - Debug MT5 authentication step by step
require_once __DIR__ . '/config/bootstrap.php';

$server = $_ENV['MT5_SERVER'];
$login = $_ENV['MT5_MANAGER_LOGIN'];
$password = $_ENV['MT5_MANAGER_PASSWORD'];

echo "Testing MT5 Authentication...\n";
echo "Server: $server\n";
echo "Login: $login\n\n";

// Initialize cURL with cookie handling
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_COOKIEFILE => '', // Enable cookies
    CURLOPT_COOKIEJAR => '', // Enable cookies
    CURLOPT_VERBOSE => true
]);

// Step 1: Auth start
echo "Step 1: Auth start...\n";
$build = '3430';
$agent = 'WebManager';
$url = "https://$server/api/auth/start?version=$build&agent=" . urlencode($agent) . "&login=$login&type=manager";

curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_POST, false);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n\n";

if ($httpCode != 200) {
    die("Auth start failed\n");
}

$data = json_decode($response, true);
if (!isset($data['srv_rand'])) {
    die("No srv_rand in response\n");
}

echo "srv_rand: {$data['srv_rand']}\n\n";

// Step 2: Calculate password hash
echo "Step 2: Calculating password hash...\n";
$password_utf16 = mb_convert_encoding($password, 'UTF-16LE', 'UTF-8');
$password_md5 = md5($password_utf16, true);
$password_hash = md5($password_md5 . 'WebAPI', true);

$srv_rand_bin = hex2bin($data['srv_rand']);
$srv_rand_answer = md5($password_hash . $srv_rand_bin);

$cli_rand_buf = random_bytes(16);
$cli_rand = bin2hex($cli_rand_buf);

echo "srv_rand_answer: $srv_rand_answer\n";
echo "cli_rand: $cli_rand\n\n";

// Step 3: Auth answer
echo "Step 3: Auth answer...\n";
$url = "https://$server/api/auth/answer?srv_rand_answer=$srv_rand_answer&cli_rand=$cli_rand";

curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_POST, false);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n\n";

if ($httpCode == 200) {
    $data = json_decode($response, true);
    if (isset($data['cli_rand_answer'])) {
        $expected = md5($password_hash . $cli_rand_buf);
        echo "cli_rand_answer: {$data['cli_rand_answer']}\n";
        echo "Expected: $expected\n";
        echo "Match: " . ($expected == $data['cli_rand_answer'] ? "YES" : "NO") . "\n";
        
        if ($expected == $data['cli_rand_answer']) {
            echo "\n✓ Authentication SUCCESSFUL!\n";
        }
    }
} else {
    echo "✗ Authentication FAILED\n";
}

curl_close($curl);
