<?php
// Test different MySQL connection methods for cPanel
require_once __DIR__ . '/config/bootstrap.php';

$host = $_ENV['DB_HOST'] ?? 'radiant-celery.metalseed.net';
$user = $_ENV['DB_USER'] ?? 'tradenotify';
$pass = $_ENV['DB_PASS'] ?? '';
$db = $_ENV['DB_NAME'] ?? 'tradenotify';

echo "Testing MySQL connections...\n\n";

// Test 1: Standard port 3306
echo "1. Testing port 3306...\n";
$socket = @fsockopen($host, 3306, $errno, $errstr, 3);
if ($socket) {
    echo "   ✓ Port 3306 is open\n";
    fclose($socket);
} else {
    echo "   ✗ Port 3306 blocked: $errstr\n";
}

// Test 2: Try common cPanel MySQL ports
$ports = [3306, 3307, 3308, 33060];
echo "\n2. Scanning common MySQL ports...\n";
foreach ($ports as $port) {
    $socket = @fsockopen($host, $port, $errno, $errstr, 2);
    if ($socket) {
        echo "   ✓ Port $port is OPEN\n";
        fclose($socket);
    } else {
        echo "   ✗ Port $port closed\n";
    }
}

// Test 3: Try connection with SSL
echo "\n3. Testing PDO connection...\n";
try {
    $dsn = "mysql:host=$host;port=3306;dbname=$db;charset=utf8mb4";
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_TIMEOUT => 5,
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    echo "   ✓ PDO connection successful!\n";
    $result = $pdo->query("SELECT 1 as test")->fetch();
    echo "   ✓ Query successful: " . json_encode($result) . "\n";
} catch (Exception $e) {
    echo "   ✗ PDO failed: " . $e->getMessage() . "\n";
}

// Test 4: Check if we can resolve the hostname
echo "\n4. DNS Resolution...\n";
$ip = gethostbyname($host);
if ($ip !== $host) {
    echo "   ✓ Hostname resolves to: $ip\n";
} else {
    echo "   ✗ Cannot resolve hostname\n";
}
