<?php
// test_db.php
require_once __DIR__ . '/config/bootstrap.php';

try {
    $pdo = get_pdo();
    echo "✓ Database connection: SUCCESS\n";
    
    // Test query
    $result = $pdo->query('SELECT DATABASE() as db');
    $row = $result->fetch();
    echo "✓ Connected to database: {$row['db']}\n";
    
    // Check tables
    $result = $pdo->query('SHOW TABLES');
    $tables = $result->fetchAll(PDO::FETCH_COLUMN);
    echo "✓ Found " . count($tables) . " tables: " . implode(', ', $tables) . "\n";
    
} catch (Exception $e) {
    echo "✗ Database connection FAILED: " . $e->getMessage() . "\n";
}
