<?php
// src/WhatsAppClient.php
class WhatsAppClient {
    private $token;
    private $phoneNumberId;
    private $businessId;

    public function __construct() {
        $this->token = $_ENV['WA_TOKEN'] ?? getenv('WA_TOKEN');
        $this->phoneNumberId = $_ENV['WA_PHONE_NUMBER_ID'] ?? getenv('WA_PHONE_NUMBER_ID');
        $this->businessId = $_ENV['WA_BUSINESS_ID'] ?? getenv('WA_BUSINESS_ID');
    }

    private function request($endpoint, $data) {
        $url = "https://graph.facebook.com/v17.0/{$this->phoneNumberId}/$endpoint";
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer {$this->token}",
            "Content-Type: application/json"
        ]);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        
        $resp = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        $errno = curl_errno($ch);
        curl_close($ch);
        
        // If curl failed, return error details
        if ($resp === false || $errno) {
            $errorMsg = json_encode([
                'curl_error' => $error,
                'curl_errno' => $errno,
                'url' => $url
            ]);
            return [0, $errorMsg];
        }
        
        return [$httpCode, $resp];
    }

    public function sendTemplate($to, $templateName, $vars = []) {
        $data = [
            "messaging_product" => "whatsapp",
            "to" => $to,
            "type" => "template",
            "template" => [
                "name" => $templateName,
                "language" => ["code" => "en_US"],
                "components" => [
                    [
                        "type" => "body",
                        "parameters" => array_map(function($v) {
                            return ["type" => "text", "text" => $v];
                        }, $vars)
                    ]
                ]
            ]
        ];
        return $this->request('messages', $data);
    }

    public function sendFreeForm($to, $text) {
        $data = [
            "messaging_product" => "whatsapp",
            "to" => $to,
            "type" => "text",
            "text" => ["body" => $text]
        ];
        return $this->request('messages', $data);
    }
}
