<?php
// router.php - Router script for PHP built-in server
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = urldecode($uri);

// Serve static files from /assets
if (preg_match('/^\/assets\//', $uri)) {
    $file = __DIR__ . $uri;
    if (file_exists($file)) {
        // Determine content type
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        $mimeTypes = [
            'js' => 'application/javascript',
            'css' => 'text/css',
            'json' => 'application/json',
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'svg' => 'image/svg+xml',
        ];
        $contentType = $mimeTypes[$ext] ?? 'application/octet-stream';
        header('Content-Type: ' . $contentType);
        readfile($file);
        return true;
    } else {
        http_response_code(404);
        echo "File not found: $uri";
        return true;
    }
}

// Serve files from /api
if (preg_match('/^\/api\//', $uri)) {
    $file = __DIR__ . $uri;
    if (file_exists($file)) {
        require $file;
        return true;
    } else {
        http_response_code(404);
        echo "API endpoint not found: $uri";
        return true;
    }
}

// Serve files from public folder
$file = __DIR__ . '/public' . $uri;
if ($uri === '/' || $uri === '') {
    $file = __DIR__ . '/public/index.php';
}
if (file_exists($file) && is_file($file)) {
    $ext = pathinfo($file, PATHINFO_EXTENSION);
    if ($ext === 'php') {
        require $file;
    } elseif ($ext === 'html') {
        header('Content-Type: text/html');
        readfile($file);
    } else {
        return false; // Let PHP serve other static files
    }
} else {
    // Try adding .php extension
    if (file_exists($file . '.php')) {
        require $file . '.php';
    } else {
        http_response_code(404);
        echo "404 Not Found: $uri";
    }
}
return true;
