# Fix php.ini SSL certificate path

Write-Host "Fixing php.ini SSL certificate configuration..." -ForegroundColor Yellow

$phpIni = "C:\php\php.ini"
$content = Get-Content $phpIni -Raw

# Fix curl.cainfo
$content = $content -replace 'curl\.cainfo=\\".+?\\"', 'curl.cainfo=C:\php\extras\ssl\cacert.pem'

# Fix openssl.cafile if exists
$content = $content -replace 'openssl\.cafile=\\".+?\\"', 'openssl.cafile=C:\php\extras\ssl\cacert.pem'

# Write back
Set-Content -Path $phpIni -Value $content -NoNewline

Write-Host "Done! Fixed php.ini" -ForegroundColor Green
Write-Host "Testing WhatsApp connection..." -ForegroundColor Yellow

# Test
php test_whatsapp.php
