<?php
// build_admin_js.php - Script to generate admin.js
$js = <<<'JAVASCRIPT'
document.addEventListener('DOMContentLoaded', function() {
const tabs = document.querySelectorAll('.tab');
const tabContent = document.getElementById('tab-content');

tabs.forEach(tab => {
tab.addEventListener('click', function() {
tabs.forEach(t => t.classList.remove('bg-opacity-100', 'font-bold'));
tab.classList.add('bg-opacity-100', 'font-bold');
loadTab(tab.getAttribute('data-tab'));
});
});

function loadTab(tab) {
switch(tab) {
case 'notifications':
tabContent.innerHTML = '<h2 class="text-xl font-bold mb-4">Saved Notifications</h2><div id="notifications-list">Loading...</div>';
fetch('/api/notifications.php').then(r=>r.json()).then(data=>{ document.getElementById('notifications-list').innerHTML = renderNotifications(data||[]); });
break;
case 'triggers':
tabContent.innerHTML = '<h2 class="text-xl font-bold mb-4">Triggers</h2><div id="triggers-list">Loading...</div>';
fetch('/api/triggers.php').then(r=>r.json()).then(data=>{ document.getElementById('triggers-list').innerHTML = renderTriggers(data||[]); });
break;
case 'templates':
tabContent.innerHTML = '<h2 class="text-xl font-bold mb-4">Templates</h2><div id="templates-list">Loading...</div>';
fetch('/api/templates.php').then(r=>r.json()).then(data=>{ document.getElementById('templates-list').innerHTML = renderTemplates(data||[]); });
break;
case 'users':
tabContent.innerHTML = '<h2 class="text-xl font-bold mb-4">Users & Accounts</h2><div id="users-list">Loading...</div>';
fetch('/api/users.php').then(r=>r.json()).then(data=>{ document.getElementById('users-list').innerHTML = renderUsers(data||[]); });
break;
case 'logs':
tabContent.innerHTML = '<h2 class="text-xl font-bold mb-4">Logs</h2><div id="logs-list">Loading...</div>';
fetch('/api/logs.php').then(r=>r.json()).then(data=>{ document.getElementById('logs-list').innerHTML = renderLogs(data||[]); });
break;
case 'settings':
tabContent.innerHTML = '<h2 class="text-xl font-bold mb-4">Settings</h2><div id="settings-list">Loading...</div>';
fetch('/api/settings.php').then(r=>r.json()).then(data=>{ document.getElementById('settings-list').innerHTML = renderSettings(data||{}); });
break;
}
}

function renderNotifications(data) {
if (!data.length) return '<div>No saved notifications. Click "Create Notification" to add one.</div>';
return '<table class="min-w-full border"><thead><tr class="bg-gray-100"><th class="border p-2">ID</th><th class="border p-2">Client</th><th class="border p-2">Trigger</th><th class="border p-2">Message</th><th class="border p-2">Status</th><th class="border p-2">Actions</th></tr></thead><tbody>' +
data.map(n=>'<tr><td class="border p-2">'+n.id+'</td><td class="border p-2">'+n.client_name+'</td><td class="border p-2">'+n.trigger_type+'</td><td class="border p-2 text-sm">'+n.message.substring(0,40)+'...</td><td class="border p-2"><span class="px-2 py-1 rounded text-xs '+(n.enabled?'bg-green-200':'bg-gray-200')+'">'+(n.enabled?'Active':'Inactive')+'</span></td><td class="border p-2"><button onclick="toggleNotification('+n.id+','+!n.enabled+')" class="text-blue-600 mr-2">'+(n.enabled?'Disable':'Enable')+'</button><button onclick="deleteNotification('+n.id+')" class="text-red-600">Delete</button></td></tr>').join('') + '</tbody></table>';
}

window.toggleNotification = function(id, enabled) {
fetch('/api/notifications.php', { method: 'POST', headers: {'Content-Type':'application/json'}, body: JSON.stringify({action:'toggle', id, enabled}) }).then(()=>loadTab('notifications'));
};

window.deleteNotification = function(id) {
if (confirm('Delete this notification rule?')) fetch('/api/notifications.php', { method: 'POST', headers: {'Content-Type':'application/json'}, body: JSON.stringify({action:'delete', id}) }).then(()=>loadTab('notifications'));
};

function renderTriggers(data) {
if (!data.length) return '<div>No triggers found.</div>';
return '<table class="min-w-full"><thead><tr><th>Name</th><th>Enabled</th><th>Threshold</th></tr></thead><tbody>' +
data.map(t=>'<tr><td>'+t.name+'</td><td><input type="checkbox" '+(t.enabled?'checked':'')+' onchange="toggleTrigger(\''+t.name+'\', this.checked)"></td><td><input type="number" value="'+(t.threshold||'')+'" min="0" style="width:80px" onchange="updateThreshold(\''+t.name+'\', this.value)"></td></tr>').join('') + '</tbody></table>';
}

window.toggleTrigger = function(name, enabled) {
fetch('/api/triggers.php', { method: 'POST', headers: {'Content-Type':'application/json'}, body: JSON.stringify({action:'toggle', name, enabled}) }).then(()=>loadTab('triggers'));
};

window.updateThreshold = function(name, value) {
fetch('/api/triggers.php', { method: 'POST', headers: {'Content-Type':'application/json'}, body: JSON.stringify({action:'threshold', name, value}) }).then(()=>loadTab('triggers'));
};

function renderTemplates(data) { return '<div>Templates placeholder</div>'; }
function renderUsers(data) { return '<div>Users placeholder</div>'; }
function renderLogs(data) { return '<div>Logs placeholder</div>'; }
function renderSettings(data) { return '<div>Settings placeholder</div>'; }

loadTab('notifications');

// Notification Modal Logic
const notificationBtn = document.getElementById('create-notification-btn');
const notificationModal = document.getElementById('notification-modal');
const step1 = document.getElementById('notification-step-1');
const step2 = document.getElementById('notification-step-2');
const step3 = document.getElementById('notification-step-3');
let selectedClients = [];
let selectedTrigger = '';

function showStep(stepNum) {
step1.classList.add('hidden');
step2.classList.add('hidden');
step3.classList.add('hidden');
if (stepNum === 1) step1.classList.remove('hidden');
if (stepNum === 2) step2.classList.remove('hidden');
if (stepNum === 3) step3.classList.remove('hidden');
}

if (notificationBtn) {
notificationBtn.onclick = function() {
notificationModal.classList.remove('hidden');
showStep(1);
document.getElementById('clients-list').innerHTML = '<div class="text-center py-4">Loading clients...</div>';
fetch('/api/mt5_accounts.php').then(r=>r.json()).then(data=>{
if (data.error) {
document.getElementById('clients-list').innerHTML = '<div class="text-red-600">Error: ' + data.error + '</div>';
} else if (!data.length) {
document.getElementById('clients-list').innerHTML = '<div>No clients found</div>';
} else {
document.getElementById('clients-list').innerHTML = data.map(client=>
'<label class="block p-3 border rounded hover:bg-gray-50 cursor-pointer"><input type="checkbox" value="'+client.clientId+'" class="client-checkbox mr-2" data-name="'+client.name+'" data-phone="'+client.phone+'" data-logins=\''+JSON.stringify(client.logins)+'\'><span class="font-semibold">'+client.name+'</span> <span class="text-gray-600 text-sm">('+client.loginCount+' account'+(client.loginCount!==1?'s':'')+')</span><div class="text-xs text-gray-500 ml-6">Accounts: '+(client.logins.join(', ')||'None')+'</div></label>'
).join('');
}
});
};
}

document.getElementById('notification-next-1').onclick = function() {
const checkboxes = document.querySelectorAll('.client-checkbox:checked');
if (checkboxes.length === 0) { alert('Please select at least one client'); return; }
selectedClients = Array.from(checkboxes).map(cb => ({ clientId: cb.value, name: cb.dataset.name, phone: cb.dataset.phone, logins: JSON.parse(cb.dataset.logins) }));
showStep(2);
};

if (document.getElementById('notification-back-2')) {
document.getElementById('notification-back-2').onclick = function() { showStep(1); };
}

document.getElementById('notification-next-2').onclick = function() {
selectedTrigger = document.getElementById('notification-trigger').value;
if (!selectedTrigger) { alert('Please select a trigger'); return; }
updatePlaceholders(selectedTrigger);
showStep(3);
};

if (document.getElementById('notification-back-3')) {
document.getElementById('notification-back-3').onclick = function() { showStep(2); };
}

function updatePlaceholders(trigger) {
const placeholders = {
'open_trade': ['{{client_name}}', '{{account_number}}', '{{symbol}}', '{{volume}}', '{{open_price}}'],
'close_trade': ['{{client_name}}', '{{account_number}}', '{{symbol}}', '{{close_price}}', '{{profit}}'],
'deposit': ['{{client_name}}', '{{account_number}}', '{{amount}}', '{{balance}}'],
'withdrawal': ['{{client_name}}', '{{account_number}}', '{{amount}}', '{{balance}}'],
'margin_call': ['{{client_name}}', '{{account_number}}', '{{margin_level}}'],
'stop_out': ['{{client_name}}', '{{account_number}}', '{{equity}}']
};
const available = placeholders[trigger] || ['{{client_name}}', '{{account_number}}'];
document.getElementById('placeholders-list').innerHTML = '<div class="mb-2 font-semibold text-gray-700">Available Placeholders:</div><div class="flex flex-wrap gap-2">' +
available.map(ph => '<button type="button" onclick="insertPlaceholder(\''+ph+'\')" class="px-3 py-1 bg-blue-100 text-blue-700 rounded text-sm hover:bg-blue-200">'+ph+'</button>').join('') + '</div>';
}

window.insertPlaceholder = function(placeholder) {
const textarea = document.getElementById('notification-message');
const start = textarea.selectionStart;
const end = textarea.selectionEnd;
const text = textarea.value;
textarea.value = text.substring(0, start) + placeholder + text.substring(end);
textarea.focus();
textarea.selectionStart = textarea.selectionEnd = start + placeholder.length;
};

if (document.getElementById('notification-save')) {
document.getElementById('notification-save').onclick = function() {
const notificationMsg = document.getElementById('notification-message').value;
if (!notificationMsg.trim()) { alert('Please enter a message'); return; }
fetch('/api/notifications.php', {
method: 'POST',
headers: {'Content-Type':'application/json'},
body: JSON.stringify({ action: 'create', clients: selectedClients, trigger: selectedTrigger, message: notificationMsg })
}).then(r=>r.json()).then(d=>{
if (d.success) { alert('Notification rule saved successfully!'); notificationModal.classList.add('hidden'); loadTab('notifications'); }
else { alert('Error: ' + (d.error || 'Unknown error')); }
});
};
}

document.getElementById('notification-cancel').onclick = function() {
if (confirm('Cancel creating this notification?')) notificationModal.classList.add('hidden');
};

});
JAVASCRIPT;

file_put_contents('assets/admin.js', $js);
echo "admin.js created successfully!\n";
