<?php
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../src/WhatsAppClient.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$wa = new WhatsAppClient();

$to = $data['phone'] ?? '';
$template = $data['template'] ?? 'hello_world';
$vars = $data['vars'] ?? [];

if (!$to) {
    echo json_encode(['success' => false, 'error' => 'Missing phone number']);
    exit;
}

list($code, $resp) = $wa->sendTemplate($to, $template, $vars);
$response = json_decode($resp, true);

if ($code == 200) {
    echo json_encode(['success' => true, 'response' => $response]);
} else {
    echo json_encode(['success' => false, 'error' => $response, 'http_code' => $code]);
}
