<?php
require_once __DIR__ . '/../config/bootstrap.php';
header('Content-Type: application/json');

$token = $_ENV['WA_TOKEN'] ?? getenv('WA_TOKEN');
$phoneId = $_ENV['WA_PHONE_NUMBER_ID'] ?? getenv('WA_PHONE_NUMBER_ID');
$businessId = $_ENV['WA_BUSINESS_ID'] ?? getenv('WA_BUSINESS_ID');

$configured = !empty($token) && !empty($phoneId);
$missing = [];

if (empty($token)) $missing[] = 'WA_TOKEN';
if (empty($phoneId)) $missing[] = 'WA_PHONE_NUMBER_ID';
if (empty($businessId)) $missing[] = 'WA_BUSINESS_ID';

echo json_encode([
    'configured' => $configured,
    'token_set' => !empty($token),
    'phone_id' => $phoneId,
    'business_id' => $businessId,
    'missing' => $missing
]);
