<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/bootstrap.php';
$pdo = get_pdo();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	$data = json_decode(file_get_contents('php://input'), true);
	if ($data['action'] === 'link_mt5') {
		$stmt = $pdo->prepare('REPLACE INTO mt5_accounts (user_id, mt5_login) VALUES (?, ?)');
		$stmt->execute([$data['id'], $data['login']]);
		echo json_encode(['success'=>true]);
		exit;
	}
	if ($data['action'] === 'toggle_sub') {
		$stmt = $pdo->prepare('UPDATE subscriptions SET enabled=? WHERE user_id=? AND trigger_id=(SELECT id FROM triggers WHERE name=?)');
		$stmt->execute([$data['enabled'] ? 1 : 0, $data['id'], $data['trigger']]);
		echo json_encode(['success'=>true]);
		exit;
	}
}
if (isset($_GET['id'])) {
	$stmt = $pdo->prepare('SELECT u.id, u.name, u.phone, a.mt5_login, u.wa_optin_at FROM users u LEFT JOIN mt5_accounts a ON u.id=a.user_id WHERE u.id=?');
	$stmt->execute([$_GET['id']]);
	$u = $stmt->fetch();
	$subs = $pdo->prepare('SELECT t.name as trigger, s.enabled FROM subscriptions s JOIN triggers t ON s.trigger_id=t.id WHERE s.user_id=?');
	$subs->execute([$_GET['id']]);
	$u['subscriptions'] = $subs->fetchAll();
	echo json_encode($u);
	exit;
}
$res = $pdo->query('SELECT u.id, u.name, u.phone, a.mt5_login, u.wa_optin_at FROM users u LEFT JOIN mt5_accounts a ON u.id=a.user_id');
echo json_encode($res->fetchAll());
