<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../src/WhatsAppClient.php';
$pdo = get_pdo();
$wa = new WhatsAppClient();
$data = json_decode(file_get_contents('php://input'), true);
$accounts = $data['accounts'] ?? [];
$trigger = $data['trigger'] ?? '';
$message = $data['message'] ?? '';
if (!$accounts || !$trigger || !$message) {
    echo json_encode(['success'=>false, 'error'=>'Missing data']);
    exit;
}
$placeholders = ['%name%', '%symbol%', '%lot%'];
$sent = 0;
foreach ($accounts as $mt5Login) {
    // Find user by MT5 login
    $stmt = $pdo->prepare('SELECT u.name, u.phone FROM users u JOIN mt5_accounts a ON u.id=a.user_id WHERE a.mt5_login=?');
    $stmt->execute([$mt5Login]);
    $user = $stmt->fetch();
    if (!$user || !$user['phone']) continue;
    // Example: replace placeholders
    $msg = str_replace('%name%', $user['name'], $message);
    // For demo, symbol/lot are static; in real use, fetch from MT5 event
    $msg = str_replace('%symbol%', 'EURUSD', $msg);
    $msg = str_replace('%lot%', '1.00', $msg);
    list($code, $resp) = $wa->sendFreeForm($user['phone'], $msg);
    if ($code == 200) $sent++;
}
if ($sent) echo json_encode(['success'=>true, 'sent'=>$sent]);
else echo json_encode(['success'=>false, 'error'=>'No messages sent']);
