<?php
require_once __DIR__ . '/../config/bootstrap.php';
header('Content-Type: application/json');
$host = $_ENV['DB_HOST'] ?? getenv('DB_HOST');
$port = (int)($_ENV['DB_PORT'] ?? getenv('DB_PORT') ?: 3306);
$start = microtime(true);
$socket = @fsockopen($host, $port, $errno, $errstr, 2.0);
if (!$socket) {
    echo json_encode(['status'=>false,'host'=>$host,'port'=>$port,'error'=>"$errno $errstr"]);
    exit;
}
@fclose($socket);
try {
    $pdo = get_pdo();
    $pdo->query('SELECT 1');
    echo json_encode(['status'=>true,'host'=>$host,'port'=>$port,'time_ms'=>round((microtime(true)-$start)*1000)]);
} catch (Throwable $e) {
    echo json_encode(['status'=>false,'host'=>$host,'port'=>$port,'error'=>$e->getMessage()]);
}