# WhatsApp Token Refresh Guide

## Issue
```
Error validating access token: Session has expired on Wednesday, 12-Nov-25 02:00:00 PST
```

Your WhatsApp access token has expired and needs to be refreshed.

## How to Get a New Token

### Option 1: Meta Business Manager (Permanent Token - Recommended)

1. **Go to Meta Business Manager:**
   https://business.facebook.com/settings/whatsapp-business-accounts

2. **Select your WhatsApp Business Account**

3. **Go to API Setup** or **System Users**

4. **Generate Permanent Token:**
   - Click "System Users" in left menu
   - Find or create a system user
   - Click "Generate New Token"
   - Select permissions:
     - `whatsapp_business_messaging`
     - `whatsapp_business_management`
   - Choose "Never Expire" or set long expiration
   - Copy the token

5. **Update `.env`:**
   ```env
   WA_TOKEN=your_new_token_here
   ```

### Option 2: Meta App Dashboard (Temporary - 24-90 days)

1. **Go to:**
   https://developers.facebook.com/apps

2. **Select your app** (or create new one)

3. **Add WhatsApp** product if not added

4. **Go to WhatsApp > Getting Started**

5. **Find "Temporary access token"**
   - Click "Generate Token"
   - Copy it

6. **Update `.env`:**
   ```env
   WA_TOKEN=your_new_token_here
   ```

### Option 3: Graph API Explorer (Testing Only)

1. **Go to:**
   https://developers.facebook.com/tools/explorer

2. **Select your app** from dropdown

3. **Select permissions:**
   - whatsapp_business_messaging
   - whatsapp_business_management

4. **Click "Generate Access Token"**

5. **Copy and update `.env`**

## Verify New Token

After updating `.env`, test:

```powershell
php test_whatsapp.php
```

Should show:
```
✓ API endpoint reachable
Phone: +your_number
Quality: GREEN
```

## Next Steps

1. Get new token from Meta Business Manager
2. Update `WA_TOKEN` in `.env`
3. Test: `php test_whatsapp.php`
4. Try web UI: http://localhost:8000/test_whatsapp.html

---

**Your current settings:**
- Phone ID: `743765942161318` ✓ Valid
- Business ID: `1125024195946461` ✓ Valid
- Token: ❌ Expired (need to refresh)
