# Database Connection via SSH Tunnel (cPanel)

Your MySQL port 3306 is blocked by firewall. cPanel hosting typically requires SSH tunneling for remote MySQL access.

## Solution: SSH Tunnel

### Step 1: Get SSH Access
In cPanel, find:
- **SSH Access** or **Terminal** 
- Get your SSH credentials (username, port - usually 22)

### Step 2: Create SSH Tunnel (PowerShell)

```powershell
# Replace with your cPanel SSH details
ssh -L 3307:localhost:3306 yourusername@radiant-celery.metalseed.net
```

This maps your local port 3307 to the server's MySQL port 3306.

### Step 3: Update .env

While tunnel is active:
```env
DB_HOST=127.0.0.1
DB_PORT=3307
```

### Alternative: Use cPanel phpMyAdmin

Since direct MySQL is blocked, you can:

1. **Export/Import via phpMyAdmin**:
   - Export your SQL from cPanel phpMyAdmin
   - Import locally OR
   - Run migrations directly in phpMyAdmin SQL tab

2. **Quick Fix - Run migrations in phpMyAdmin**:
   - Open: https://radiant-celery.metalseed.net:2083/cpsess.../sql/
   - Click SQL tab
   - Copy contents of `database/notifications_migration.sql`
   - Execute in phpMyAdmin

## Recommended: Run Migrations in phpMyAdmin NOW

Since you have cPanel access open:

1. Go to phpMyAdmin in your cPanel
2. Select database: `tradenotify`
3. Click **SQL** tab
4. Copy and paste this:

