# TradeNotify

A PHP 8.2 web app for MT5 event notifications via WhatsApp Cloud API.

## Setup
1. Create MySQL DB and user.
2. Copy `.env.example` to `.env` and fill in credentials.
3. Run migrations and seeders.
4. Set up webhook endpoint `/webhooks/mt5` (see below).
5. Configure cron for `php bin/dispatch.php`.

## Webhook Verification
- POST to `/webhooks/mt5` with JSON body and header `X-MT5-Signature` (HMAC SHA256 of body using `WEBHOOK_SECRET`).

## WhatsApp API
- Env vars: `WA_TOKEN`, `WA_PHONE_NUMBER_ID`, `WA_BUSINESS_ID`.
- Supports template and free-form sends.

## Example cURL
```
curl -X POST https://yourdomain/webhooks/mt5 \
  -H "X-MT5-Signature: ..." \
  -H "Content-Type: application/json" \
  -d '{"event":"TRADE_OPEN", ...}'
```

## Acceptance Tests
- TRADE_OPEN webhook → WhatsApp message sent/logged
- DEPOSIT/WITHDRAWAL → correct template vars
- Trigger toggled off → no message
- Force 429 → dispatcher retries/logs
