# Database Connection Troubleshooting

## Current Issue
Connection to `radiant-celery.metalseed.net:3306` is timing out.

**Error:** `SQLSTATE[HY000] [2002] A connection attempt failed because the connected party did not properly respond`

---

## Quick Tests

### 1. Test Database Connectivity
```powershell
php api/db_health.php
```

**Expected when working:**
```json
{"status":true,"host":"radiant-celery.metalseed.net","port":3306,"time_ms":150}
```

**Current result:**
```json
{"status":false,"host":"radiant-celery.metalseed.net","port":3306,"error":"10060 ..."}
```

---

## Troubleshooting Steps

### Step 1: Check Network Connectivity
```powershell
# Test if host is reachable
ping radiant-celery.metalseed.net

# Test if port 3306 is open
Test-NetConnection -ComputerName radiant-celery.metalseed.net -Port 3306
```

**What to look for:**
- ✓ Ping successful = DNS resolves and host is reachable
- ✗ Ping timeout = Network/firewall issue or host is down
- ✓ Port 3306 open = MySQL is listening
- ✗ Port 3306 closed = Firewall blocking or MySQL not configured for remote access

---

### Step 2: Check Firewall Rules
```powershell
# Check Windows Firewall outbound rules
Get-NetFirewallRule | Where-Object {$_.Direction -eq "Outbound" -and $_.Enabled -eq "True"}
```

**Common issues:**
- Corporate firewall blocking port 3306
- Windows Firewall blocking outbound MySQL connections
- ISP blocking database ports

**Solutions:**
- Add firewall exception for port 3306
- Use VPN if required by your organization
- Contact network admin to whitelist the database server

---

### Step 3: Verify Database Server Configuration
The database server needs to:
1. Allow remote connections (not just localhost)
2. Have your IP address whitelisted
3. Be running and accessible

**Check with hosting provider:**
- Is remote MySQL access enabled?
- Is your current IP whitelisted? (Check your IP: https://whatismyip.com)
- Are there any VPN/network requirements?

---

### Step 4: Test Credentials (if connection works)
```powershell
# Once connection is established, test login
php test_db.php
```

---

## Solutions by Priority

### Option 1: Use Local MySQL (Recommended for Development)
**Install MySQL locally:**

1. Download MySQL: https://dev.mysql.com/downloads/installer/
2. Install and set root password
3. Create database:
```sql
CREATE DATABASE tradenotify;
CREATE USER 'tradenotify'@'localhost' IDENTIFIED BY 'your_password';
GRANT ALL PRIVILEGES ON tradenotify.* TO 'tradenotify'@'localhost';
FLUSH PRIVILEGES;
```

4. Update `.env`:
```env
DB_HOST=127.0.0.1
DB_PORT=3306
DB_NAME=tradenotify
DB_USER=tradenotify
DB_PASS=your_password
```

5. Run migrations:
```powershell
php api/run_migrations.php
```

---

### Option 2: Use SQLite (Quickest for Testing)
No installation needed, file-based database.

**Changes required:**
1. Update `config/bootstrap.php` to use SQLite
2. Run migrations with SQLite syntax
3. No network dependency

---

### Option 3: Fix Remote Connection
**If you need to use the remote database:**

1. **Contact database administrator** to:
   - Whitelist your IP address
   - Confirm MySQL is configured for remote access
   - Check if VPN is required

2. **Check `.env` credentials:**
   - Hostname: `radiant-celery.metalseed.net`
   - Port: `3306`
   - Username: `tradenotify`
   - Password: `HI2(MD6aVBG!+@gH`

3. **Test with MySQL client:**
```powershell
# Install MySQL client and test connection
mysql -h radiant-celery.metalseed.net -P 3306 -u tradenotify -p
```

---

## Verification Checklist

After fixing database connection:

- [ ] `php api/db_health.php` returns `"status":true`
- [ ] `php api/run_migrations.php` completes successfully
- [ ] `php test_db.php` can query the database
- [ ] Saving notification rules in UI works
- [ ] `SELECT * FROM notifications` shows saved rules

---

## Current Status

✓ **WhatsApp:** Configured and ready
✓ **MT5 API:** Connected and working
✗ **Database:** Connection timeout - blocking save functionality

**Next action:** Choose Option 1 (local MySQL) or Option 2 (SQLite) to unblock development.
