# ✅ COMPLETE SETUP GUIDE - TradeNotify

## STATUS CHECK

✅ **Groups Added:**
- `skylinkscapital\A\Basic`
- `demo\SK\G1`

✅ **Frontend Ready:**
- Create notification button ✓
- Notifications list display ✓
- Toggle enable/disable ✓
- Delete notification ✓

❌ **Database Tables:** Need to be created

---

## 🎯 STEP 1: Create Database Tables

### Option A: Via phpMyAdmin (Recommended)

1. **Open phpMyAdmin** in your cPanel:
   - Go to: https://radiant-celery.metalseed.net:2083
   - Login with your credentials
   - Click **phpMyAdmin** icon

2. **Select Database:**
   - Click `tradenotify` in the left sidebar

3. **Run Migration:**
   - Click **SQL** tab at the top
   - Open the file: `D:\WHATSAPPTHING\SETUP_DATABASE.sql`
   - Copy ALL the SQL code
   - Paste into the SQL box
   - Click **Go** button

4. **Verify:**
   - You should see: "3 tables created successfully"
   - Check left sidebar for:
     - ✓ notifications
     - ✓ notification_history
     - ✓ notification_checkpoints

---

## 🎯 STEP 2: Test the Application

### A. Access the Dashboard
```
http://localhost:8000
```

### B. Create a Notification

1. Click **"Create Notification"** button
2. **Step 1 - Select Clients:**
   - You'll see clients from both groups:
     - skylinkscapital\A\Basic
     - demo\SK\G1
   - Check the clients you want to notify
   - For clients with multiple accounts, select specific accounts
   - Click **Next**

3. **Step 2 - Select Trigger:**
   - Choose trigger type:
     - ✓ Open Trade (when client opens a position)
     - Close Trade
     - Deposit
     - Withdrawal
     - Margin Call
     - Stop Out
   - Click **Next**

4. **Step 3 - Compose Message:**
   - Write your WhatsApp message
   - Use placeholders:
     - `{{client_name}}` - Client's name
     - `{{account_login}}` - Account number
     - `{{symbol}}` - Trading symbol (e.g., EURUSD)
     - `{{volume}}` - Trade volume
     - `{{price}}` - Trade price
     - `{{profit}}` - Current profit/loss
   - Example:
     ```
     Hello {{client_name}},
     Your account {{account_login}} has opened a trade:
     Symbol: {{symbol}}
     Volume: {{volume}}
     Price: {{price}}
     ```
   - Click **Save Notification Rule**

### C. View Saved Notifications

After saving, you'll see your notification in the **Notifications** tab:

| ID | Client | Trigger | Message | Status | Actions |
|----|--------|---------|---------|--------|---------|
| 1 | John Doe | open_trade | Hello {{client_name}}... | Active | Disable / Delete |

### D. Manage Notifications

**Toggle On/Off:**
- Click **Disable** to pause notifications
- Click **Enable** to activate again

**Delete:**
- Click **Delete** button
- Confirm deletion
- Notification removed permanently

---

## 🎯 STEP 3: Monitor & Send Messages

### A. Manual Testing

Test if WhatsApp integration works:
```powershell
php test_wa_send.php
```

### B. Automatic Monitoring (Background Process)

Run the monitoring script to detect trades and send WhatsApp messages:

```powershell
php cli/monitor_triggers.php
```

This will:
- Check all enabled notifications every 30 seconds
- Query MT5 for new deals/trades
- Match with notification rules
- Send WhatsApp messages with replaced placeholders
- Track sent messages to avoid duplicates

**For production, run as a service or scheduled task**

---

## 📊 SUMMARY

### What You Can Do Now:

1. ✅ **Create Notification Rules**
   - Select clients from both groups
   - Choose trigger type
   - Write custom message with placeholders

2. ✅ **View All Notifications**
   - See all saved rules in a table
   - Check status (Active/Inactive)
   - See which clients and triggers

3. ✅ **Enable/Disable Notifications**
   - Toggle on/off without deleting
   - Temporarily pause notifications

4. ✅ **Delete Notifications**
   - Remove unwanted rules
   - Confirmation required

5. ✅ **Automatic WhatsApp Messages**
   - Monitor script detects trades
   - Sends personalized WhatsApp messages
   - Tracks history to avoid duplicates

---

## 🔧 Next Steps

1. **Run the SQL in phpMyAdmin** (see STEP 1)
2. **Refresh the dashboard** at http://localhost:8000
3. **Create your first notification rule**
4. **Test it** by opening a trade on MT5

---

## 📞 Support

If you encounter any issues:
- Check `php api/db_health.php` - Should return `"status":true`
- Check browser console for errors (F12)
- Check PHP server terminal for errors

